// Simple AI Generator - Text Expansion Mode
console.log('🤖 Simple AI Generator Loaded - Text Expansion Mode');

// Main function to expand existing text in textarea
window.expandExistingText = async function(context = 'general') {
    console.log('🚀 Expand Text Called with context:', context);
    
    // Get textarea content
    const textarea = document.getElementById('deskripsi');
    if (!textarea) {
        console.error('❌ Textarea not found');
        return;
    }
    
    const existingText = textarea.value.trim();
    if (!existingText) {
        alert('Harap tulis teks singkat di deskripsi terlebih dahulu!\nContoh: "ringkas", "pembelajaran", "proyek web", dll.');
        textarea.focus();
        return;
    }
    
    // Show loading
    const btn = document.getElementById('generateDescriptionBtn');
    const icon = btn?.querySelector('i');
    const text = btn?.querySelector('span');
    const status = document.getElementById('aiStatus');
    
    if (btn) {
        btn.disabled = true;
        if (icon) icon.className = 'spinner-border spinner-border-sm';
        if (text) text.textContent = 'Tunggu sebentar yahh..';
    }
    
    if (status) {
        status.style.display = 'block';
        const statusText = status.querySelector('#aiStatusText');
        if (statusText) statusText.textContent = 'Sedang mengembangkan teks...';
    }
    
    try {
        // Prepare form data
        const formData = new FormData();
        formData.append('existing_text', existingText);
        formData.append('context', context);
        
        // Get base URL
        const baseUrl = window.location.origin + '/';
        const apiUrl = baseUrl + 'api/ai/expand-text';
        console.log('📤 Sending to API:', apiUrl);
        console.log('📝 Text to expand:', existingText);
        
        // Call API
        const response = await fetch(apiUrl, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        });
        
        console.log('📥 Response status:', response.status);
        const result = await response.json();
        console.log('📋 API Result:', result);
        
        if (result.success && result.text) {
            // SUCCESS - Replace with expanded text
            textarea.value = result.text;
            console.log('✅ Success: Text expanded');
            
            if (status) {
                const statusText = status.querySelector('#aiStatusText');
                if (statusText) statusText.textContent = 'Teks berhasil dikembangkan!';
                
                setTimeout(() => {
                    status.style.display = 'none';
                }, 3000);
            }
            
            showSimpleAlert('✅ Teks berhasil dikembangkan menjadi deskripsi lengkap!', 'success');
            
        } else {
            // FALLBACK - Expand using template
            console.log('⚠️ Using fallback expansion');
            const expandedText = generateExpandedFallback(existingText, context);
            
            textarea.value = expandedText;
            console.log('✅ Fallback: Text expanded');
            
            if (status) {
                const statusText = status.querySelector('#aiStatusText');
                if (statusText) statusText.textContent = 'Teks dikembangkan dengan template';
            }
            
            showSimpleAlert('✅ Teks berhasil dikembangkan (template)!', 'info');
        }
        
    } catch (error) {
        console.error('❌ Error:', error);
        
        // FALLBACK on error
        const expandedText = generateExpandedFallback(existingText, context);
        textarea.value = expandedText;
        console.log('✅ Error Fallback: Text expanded');
        
        if (status) {
            const statusText = status.querySelector('#aiStatusText');
            if (statusText) statusText.textContent = 'Teks dikembangkan dengan template';
        }
        
        showSimpleAlert('✅ Teks berhasil dikembangkan (alternatif)!', 'warning');
    }
    
    // Reset button
    if (btn) {
        btn.disabled = false;
        if (icon) icon.className = 'bi bi-magic';
        if (text) text.textContent = 'Generate AI';
    }
    
    console.log('🏁 Expand Text Completed');
};

// Fallback text expander - intelligently expands short text
function generateExpandedFallback(shortText, context) {
    const text = shortText.toLowerCase().trim();
    
    // Smart expansion based on keywords
    if (text.includes('ringkas') || text.includes('singkat')) {
        return `Deskripsi ini dibuat secara ringkas namun komprehensif untuk memberikan gambaran yang jelas dan mudah dipahami. Pendekatan ringkas ini memungkinkan informasi penting dapat disampaikan dengan efektif tanpa mengurangi kualitas dan substansi dari konten yang disampaikan. Hal ini sangat berguna untuk memastikan bahwa pembaca dapat dengan cepat memahami inti dari informasi yang disajikan.`;
    }
    
    if (text.includes('pembelajaran') || text.includes('belajar')) {
        return `Proses pembelajaran ini memberikan pengalaman yang sangat berharga dalam mengembangkan kemampuan dan wawasan baru. Melalui berbagai metode pembelajaran yang interaktif dan praktis, saya dapat memperoleh pemahaman yang mendalam tentang materi yang dipelajari. Pembelajaran ini tidak hanya memberikan pengetahuan teoritis, tetapi juga keterampilan praktis yang dapat langsung diaplikasikan dalam kehidupan sehari-hari maupun dalam konteks profesional.`;
    }
    
    if (text.includes('proyek') || text.includes('project')) {
        return `Proyek ini dikembangkan dengan menggunakan metodologi yang terstruktur dan mengikuti best practices dalam pengembangan. Setiap tahapan proyek dirancang dengan cermat untuk memastikan hasil yang optimal dan sesuai dengan kebutuhan yang telah ditetapkan. Proyek ini melibatkan berbagai aspek teknis dan non-teknis yang memerlukan koordinasi yang baik antar tim untuk mencapai tujuan yang diinginkan.`;
    }
    
    if (text.includes('pelatihan') || text.includes('training')) {
        return `Pelatihan ini dirancang untuk memberikan pengetahuan dan keterampilan yang relevan dengan kebutuhan industri saat ini. Materi pelatihan disusun secara sistematis dan disampaikan oleh instruktur yang berpengalaman di bidangnya. Peserta pelatihan akan mendapatkan pengalaman hands-on yang memungkinkan mereka untuk langsung mempraktikkan apa yang telah dipelajari dalam situasi nyata.`;
    }
    
    if (text.includes('organisasi') || text.includes('kegiatan')) {
        return `Kegiatan organisasi ini memberikan kesempatan yang sangat baik untuk mengembangkan kemampuan leadership, teamwork, dan komunikasi. Melalui berbagai program dan aktivitas yang diselenggarakan, anggota organisasi dapat belajar bekerja sama dalam tim, mengelola proyek, dan berkontribusi positif bagi masyarakat. Pengalaman berorganisasi ini juga membantu dalam membangun jaringan profesional yang luas.`;
    }
    
    if (text.includes('sertifikat') || text.includes('certificate')) {
        return `Sertifikat ini merupakan pengakuan resmi terhadap kompetensi dan pengetahuan yang telah diperoleh melalui proses pembelajaran dan evaluasi yang ketat. Proses sertifikasi melibatkan berbagai tahapan penilaian yang komprehensif untuk memastikan bahwa pemegang sertifikat benar-benar memiliki kemampuan yang sesuai dengan standar yang ditetapkan. Sertifikat ini menjadi bukti kredibilitas dan komitmen terhadap pengembangan profesional berkelanjutan.`;
    }
    
    // Generic expansion for any other text
    return `${shortText} merupakan bagian penting yang memberikan kontribusi signifikan dalam pengembangan kemampuan dan wawasan. Melalui pengalaman ini, dapat diperoleh pembelajaran yang berharga dan keterampilan yang berguna untuk masa depan. Hal ini tidak hanya memberikan manfaat dalam konteks akademis atau profesional, tetapi juga dalam pengembangan personal yang berkelanjutan. Pengalaman ini menjadi fondasi yang kuat untuk menghadapi tantangan dan peluang yang akan datang di masa mendatang.`;
}

// Simple alert function
function showSimpleAlert(message, type = 'info') {
    // Remove existing alerts
    const existingAlerts = document.querySelectorAll('.simple-alert');
    existingAlerts.forEach(alert => alert.remove());
    
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${type} simple-alert`;
    alertDiv.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        padding: 15px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        font-weight: 500;
    `;
    
    alertDiv.innerHTML = `
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()" style="float: right; background: none; border: none; font-size: 20px; cursor: pointer;">&times;</button>
    `;
    
    document.body.appendChild(alertDiv);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (alertDiv.parentNode) {
            alertDiv.remove();
        }
    }, 5000);
}

// Specific functions for each type - now using text expansion
window.generateActivityDescription = function() {
    console.log('🎯 Activity Generate Called');
    expandExistingText('aktivitas');
};

window.generateTrainingDescription = function() {
    console.log('🎯 Training Generate Called');
    expandExistingText('pelatihan');
};

window.generateProjectDescription = function() {
    console.log('🎯 Project Generate Called');
    expandExistingText('proyek');
};

window.generateOrganizationDescription = function() {
    console.log('🎯 Organization Generate Called');
    expandExistingText('organisasi');
};

window.generateCertificateDescription = function() {
    console.log('🎯 Certificate Generate Called');
    expandExistingText('sertifikat');
};

console.log('✅ Simple AI Generator Ready!');